#include <iostream>
#include <vector>
#include <set>
#include <map>
#include <unordered_map>
#include <random>
#include <time.h>
#include <math.h>
#include <algorithm>
#include <iomanip>
typedef long long ll;
typedef long double ld;
using namespace std;


struct point{
	ld x, y;

};

struct line{
	ld a, b, c;

	void set(point & o, point & t){
		a = t.y - o.y;
		b = o.x - t.x;
		c = - a * o.x - b * o.y;
	}


};
	ld eps = 1e-6;

point sub(point a, point b){
	return {a.x - b.x, a.y - b.y};
}

ld par(point x, point y){
	return abs(x.x * y.y - x.y * y.x) < eps;
}

ld tmp(point a, point b){
	return ((a.x * b.x + a.y * b.y) >= 0);
}

struct segment{
	point a, b;

	bool check(point c){
		return par(sub(c, a), sub(b, a)) && tmp(sub(c, a), sub(b, a)) && tmp(sub(c, b), sub(a, b));
	}
};

bool check(line l1, line l2){
	if (abs(l1.a * l2.b - l1.b * l2.a) < eps) return false;
	return true;
}

point intersection(line l1, line l2){
	ld y = -(l1.a * l2.c - l1.c * l2.a) / (l1.a * l2.b - l1.b * l2.a);
	ld x;
	if (abs(l1.a) < eps) x = (-l2.c - l2.b * y) / l2.a;
	else x = (-l1.c - l1.b * y) / l1.a;
	return {x, y};
}

bool intersect(segment a, segment b){
	line l1;
	l1.set(a.a, a.b);
	line l2;
	l2.set(b.a, b.b);


	// cout << "B\n";
	// cout << l1.a << ' ' << l2.b << ' ' << l1.b << ' ' << l2.a << '\n';
	// cout << a.a.x << ' ' << l2.b << ' ' << l1.b << ' ' << l2.a << '\n';
	if (!check(l1, l2)) return false;

	// cout << "A\n";

	point p = intersection(l1, l2);

	// cout << '\t' << p.x << ' ' << p.y << '\n';
	// cout << a.check(p) << ' ' << b.check(p) << '\n';
	return a.check(p) && b.check(p);
}

void dfs(int v, vector<vector<int>> & g, vector<int> & cl, int color){
	cl[v] = color;
	for (auto & to: g[v]){
		if (cl[to] == -1) dfs(to, g, cl, color);
	}
}

void solve(){
	int n;
	cin >> n;

	vector<segment> v;

	for (int i = 0; i < n; i++){
		ld x1, y1, x2, y2;
		cin >> x1 >> y1 >> x2 >> y2;
		point a = {x1, y1};
		point b = {x2, y2};
		v.push_back({a, b});
	}

	vector<vector<int>> g(n);
	for (int i = 0; i < n - 1; i++){
		for (int j = i + 1; j < n; j++){
			// cout << i << ' ' << j << '\n';
			if (!intersect(v[i], v[j])) continue;
			g[i].push_back(j);
			g[j].push_back(i);
		}
	}

	// for (auto & i: g) {
		// for (auto& j: i) cout << j << ' ';
			// cout << endl;
	// }

	vector<int> cl(n, -1);
	int color = 0;
	for (int i = 0; i < n; i++){
		if (cl[i] == -1) dfs(i, g, cl, color++);
	}
	vector<int> cnt_v(color), cnt_e(color);
	for (int i = 0; i < n; i++){
		cnt_v[cl[i]]++;
		cnt_e[cl[i]] += g[i].size();
	}
	// for (auto & i: cl) cout << i << ' ';
		// cout << '\n';
	int ans = 0;
	for (int i = 0; i < color; i++){
		ans += 1 + cnt_e[i]/2 - cnt_v[i];
	}
	cout << ans + 1 << '\n';
}

int main(){
	ios_base::sync_with_stdio(false);
	cin.tie(0);

	// cout << (987654321 - 12345678) << ' ' << 9 * (123456789 - 12345678) << '\n';

	int t;
	cin >> t;
	while (t--){
		solve();
	}
	return 0;
}